<?php
/*
 * Copyright 2005-2015 Centreon
 * Centreon is developped by : Julien Mathis and Romain Le Merlus under
 * GPL Licence 2.0.
 * 
 * This program is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU General Public License as published by the Free Software 
 * Foundation ; either version 2 of the License.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with 
 * this program; if not, see <http://www.gnu.org/licenses>.
 * 
 * Linking this program statically or dynamically with other modules is making a 
 * combined work based on this program. Thus, the terms and conditions of the GNU 
 * General Public License cover the whole combination.
 * 
 * As a special exception, the copyright holders of this program give Centreon 
 * permission to link this program with independent modules to produce an executable, 
 * regardless of the license terms of these independent modules, and to copy and 
 * distribute the resulting executable under terms of Centreon choice, provided that 
 * Centreon also meet, for each linked independent module, the terms  and conditions 
 * of the license of that module. An independent module is a module which is not 
 * derived from this program. If you modify this program, you may extend this 
 * exception to your version of the program, but you are not obliged to do so. If you
 * do not wish to do so, delete this exception statement from your version.
 * 
 * For more information : contact@centreon.com
 * 
 */

if (!isset($oreon)) {
    exit();
}

function testExistence($name = null)
{
    global $pearDB;
    global $form;

    CentreonDependency::purgeObsoleteDependencies($pearDB);

    $id = null;
    if (isset($form)) {
        $id = $form->getSubmitValue('dep_id');
    }
    $query = "SELECT dep_name, dep_id FROM dependency WHERE dep_name = '" .
        htmlentities($name, ENT_QUOTES, "UTF-8") . "'";
    $DBRESULT = $pearDB->query($query);
    $dep = $DBRESULT->fetchRow();
    #Modif case
    if ($DBRESULT->rowCount() >= 1 && $dep["dep_id"] == $id) {
        return true;
    } #Duplicate entry
    elseif ($DBRESULT->rowCount() >= 1 && $dep["dep_id"] != $id) {
        return false;
    } else {
        return true;
    }
}

function testCycle($childs = null)
{
    global $pearDB;
    global $form;
    $parents = array();
    $childs = array();
    if (isset($form)) {
        $parents = $form->getSubmitValue('dep_msParents');
        $childs = $form->getSubmitValue('dep_msChilds');
        $childs = array_flip($childs);
    }
    foreach ($parents as $parent) {
        if (array_key_exists($parent, $childs)) {
            return false;
        }
    }
    return true;
}

function deleteMetaServiceDependencyInDB($dependencies = array())
{
    global $pearDB;
    foreach ($dependencies as $key => $value) {
        $DBRESULT = $pearDB->query("DELETE FROM dependency WHERE dep_id = '" . $key . "'");
    }
}

function multipleMetaServiceDependencyInDB($dependencies = array(), $nbrDup = array())
{
    foreach ($dependencies as $key => $value) {
        global $pearDB;
        $DBRESULT = $pearDB->query("SELECT * FROM dependency WHERE dep_id = '" . $key . "' LIMIT 1");
        $row = $DBRESULT->fetchRow();
        $row["dep_id"] = '';
        for ($i = 1; $i <= $nbrDup[$key]; $i++) {
            $val = null;
            foreach ($row as $key2 => $value2) {
                $key2 == "dep_name" ? ($dep_name = $value2 = $value2 . "_" . $i) : null;
                $val
                    ? $val .= ($value2 != null ? (", '" . $value2 . "'") : ", NULL")
                    : $val .= ($value2 != null ? ("'" . $value2 . "'") : "NULL");
            }
            if (testExistence($dep_name)) {
                $val ? $rq = "INSERT INTO dependency VALUES (" . $val . ")" : $rq = null;
                $pearDB->query($rq);
                $DBRESULT = $pearDB->query("SELECT MAX(dep_id) FROM dependency");
                $maxId = $DBRESULT->fetchRow();
                if (isset($maxId["MAX(dep_id)"])) {
                    $query = "SELECT DISTINCT meta_service_meta_id FROM dependency_metaserviceParent_relation " .
                        "WHERE dependency_dep_id = '" . $key . "'";
                    $DBRESULT = $pearDB->query($query);
                    while ($ms = $DBRESULT->fetchRow()) {
                        $query = "INSERT INTO dependency_metaserviceParent_relation " .
                            "VALUES ('', '" . $maxId["MAX(dep_id)"] . "', '" . $ms["meta_service_meta_id"] . "')";
                        $pearDB->query($query);
                    }
                    $DBRESULT->closeCursor();
                    $query = "SELECT DISTINCT meta_service_meta_id FROM dependency_metaserviceChild_relation " .
                        "WHERE dependency_dep_id = '" . $key . "'";
                    $DBRESULT = $pearDB->query($query);
                    while ($ms = $DBRESULT->fetchRow()) {
                        $query = "INSERT INTO dependency_metaserviceChild_relation VALUES ('', '" .
                            $maxId["MAX(dep_id)"] . "', '" . $ms["meta_service_meta_id"] . "')";
                        $pearDB->query($query);
                    }
                    $DBRESULT->closeCursor();
                }
            }
        }
    }
}

function updateMetaServiceDependencyInDB($dep_id = null)
{
    if (!$dep_id) {
        exit();
    }
    updateMetaServiceDependency($dep_id);
    updateMetaServiceDependencyMetaServiceParents($dep_id);
    updateMetaServiceDependencyMetaServiceChilds($dep_id);
}

function insertMetaServiceDependencyInDB()
{
    $dep_id = insertMetaServiceDependency();
    updateMetaServiceDependencyMetaServiceParents($dep_id);
    updateMetaServiceDependencyMetaServiceChilds($dep_id);
    return ($dep_id);
}

function insertMetaServiceDependency()
{
    global $form;
    global $pearDB;
    $ret = array();
    $ret = $form->getSubmitValues();
    $rq = "INSERT INTO dependency ";
    $rq .= "(dep_name, dep_description, inherits_parent, execution_failure_criteria, " .
        "notification_failure_criteria, dep_comment) ";
    $rq .= "VALUES (";
    isset($ret["dep_name"]) && $ret["dep_name"] != null
        ? $rq .= "'" . htmlentities($ret["dep_name"], ENT_QUOTES, "UTF-8") . "', "
        : $rq .= "NULL, ";
    isset($ret["dep_description"]) && $ret["dep_description"] != null
        ? $rq .= "'" . htmlentities($ret["dep_description"], ENT_QUOTES, "UTF-8") . "', "
        : $rq .= "NULL, ";
    isset($ret["inherits_parent"]["inherits_parent"]) && $ret["inherits_parent"]["inherits_parent"] != null
        ? $rq .= "'" . $ret["inherits_parent"]["inherits_parent"] . "', "
        : $rq .= "NULL, ";
    isset($ret["execution_failure_criteria"]) && $ret["execution_failure_criteria"] != null
        ? $rq .= "'" . implode(",", array_keys($ret["execution_failure_criteria"])) . "', "
        : $rq .= "NULL, ";
    isset($ret["notification_failure_criteria"]) && $ret["notification_failure_criteria"] != null
        ? $rq .= "'" . implode(",", array_keys($ret["notification_failure_criteria"])) . "', "
        : $rq .= "NULL, ";
    isset($ret["dep_comment"]) && $ret["dep_comment"] != null
        ? $rq .= "'" . htmlentities($ret["dep_comment"], ENT_QUOTES, "UTF-8") . "' "
        : $rq .= "NULL ";
    $rq .= ")";
    $pearDB->query($rq);
    $DBRESULT = $pearDB->query("SELECT MAX(dep_id) FROM dependency");
    $dep_id = $DBRESULT->fetchRow();
    return ($dep_id["MAX(dep_id)"]);
}

function updateMetaServiceDependency($dep_id = null)
{
    if (!$dep_id) {
        exit();
    }
    global $form;
    global $pearDB;
    $ret = array();
    $ret = $form->getSubmitValues();
    $rq = "UPDATE dependency SET ";
    $rq .= "dep_name = ";
    isset($ret["dep_name"]) && $ret["dep_name"] != null
        ? $rq .= "'" . htmlentities($ret["dep_name"], ENT_QUOTES, "UTF-8") . "', "
        : $rq .= "NULL, ";
    $rq .= "dep_description = ";
    isset($ret["dep_description"]) && $ret["dep_description"] != null
        ? $rq .= "'" . htmlentities($ret["dep_description"], ENT_QUOTES, "UTF-8") . "', "
        : $rq .= "NULL, ";
    $rq .= "inherits_parent = ";
    isset($ret["inherits_parent"]["inherits_parent"]) && $ret["inherits_parent"]["inherits_parent"] != null
        ? $rq .= "'" . $ret["inherits_parent"]["inherits_parent"] . "', "
        : $rq .= "NULL, ";
    $rq .= "execution_failure_criteria = ";
    isset($ret["execution_failure_criteria"]) && $ret["execution_failure_criteria"] != null
        ? $rq .= "'" . implode(",", array_keys($ret["execution_failure_criteria"])) . "', "
        : $rq .= "NULL, ";
    $rq .= "notification_failure_criteria = ";
    isset($ret["notification_failure_criteria"]) && $ret["notification_failure_criteria"] != null
        ? $rq .= "'" . implode(",", array_keys($ret["notification_failure_criteria"])) . "', "
        : $rq .= "NULL, ";
    $rq .= "dep_comment = ";
    isset($ret["dep_comment"]) && $ret["dep_comment"] != null
        ? $rq .= "'" . htmlentities($ret["dep_comment"], ENT_QUOTES, "UTF-8") . "' "
        : $rq .= "NULL ";
    $rq .= "WHERE dep_id = '" . $dep_id . "'";
    $pearDB->query($rq);
}

function updateMetaServiceDependencyMetaServiceParents($dep_id = null)
{
    if (!$dep_id) {
        exit();
    }
    global $form;
    global $pearDB;
    $rq = "DELETE FROM dependency_metaserviceParent_relation ";
    $rq .= "WHERE dependency_dep_id = '" . $dep_id . "'";
    $DBRESULT = $pearDB->query($rq);
    $ret = array();
    $ret = CentreonUtils::mergeWithInitialValues($form, 'dep_msParents');
    for ($i = 0; $i < count($ret); $i++) {
        $rq = "INSERT INTO dependency_metaserviceParent_relation ";
        $rq .= "(dependency_dep_id, meta_service_meta_id) ";
        $rq .= "VALUES ";
        $rq .= "('" . $dep_id . "', '" . $ret[$i] . "')";
        $DBRESULT = $pearDB->query($rq);
    }
}

function updateMetaServiceDependencyMetaServiceChilds($dep_id = null)
{
    if (!$dep_id) {
        exit();
    }
    global $form;
    global $pearDB;
    $rq = "DELETE FROM dependency_metaserviceChild_relation ";
    $rq .= "WHERE dependency_dep_id = '" . $dep_id . "'";
    $DBRESULT = $pearDB->query($rq);
    $ret = array();
    $ret = CentreonUtils::mergeWithInitialValues($form, 'dep_msChilds');
    for ($i = 0; $i < count($ret); $i++) {
        $rq = "INSERT INTO dependency_metaserviceChild_relation ";
        $rq .= "(dependency_dep_id, meta_service_meta_id) ";
        $rq .= "VALUES ";
        $rq .= "('" . $dep_id . "', '" . $ret[$i] . "')";
        $DBRESULT = $pearDB->query($rq);
    }
}
